/*
 * Decompiled with CFR 0.152.
 */
package emulator.util.file;

import emulator.hardware.memory.MemoryBlockInterface;
import emulator.shell.DebugShell;
import emulator.util.file.FileLoadStrategy;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileLoadStrategyPcVic
implements FileLoadStrategy {
    static Logger logger = LogManager.getLogger((String)FileLoadStrategyPcVic.class.getName());

    @Override
    public void loadToMemory(String file_name, MemoryBlockInterface memory, int start_address, int block_size) {
        block12: {
            FileInputStream file = null;
            try {
                try {
                    file = new FileInputStream(file_name);
                    this.skipInput(file, 24);
                    int register_block_size = file.read();
                    this.skipInput(file, register_block_size += 256 * file.read());
                    this.readByterun(file, memory, 0, 32768);
                    this.readByterun(file, memory, 36864, 12288);
                }
                catch (IOException e) {
                    DebugShell.getInstance().getErr().println("File read failed for \"" + file_name + "\" (prg): " + e.getMessage());
                    if (file == null) break block12;
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void readByterun(FileInputStream file, MemoryBlockInterface memory, int start, int count) throws IOException {
        block0: while (count > 0) {
            int leader_byte = file.read();
            if (leader_byte < 0) break;
            if (leader_byte < 128) {
                int i = 0;
                while (i <= leader_byte) {
                    int by = file.read();
                    if (by < 0) continue block0;
                    memory.getData()[start++] = (byte)by;
                    --count;
                    ++i;
                }
                continue;
            }
            if (leader_byte <= 128) continue;
            int by = file.read();
            if (by < 0) break;
            int i = 0;
            while (i < 257 - leader_byte) {
                memory.getData()[start++] = (byte)by;
                --count;
                ++i;
            }
        }
        if (count > 0) {
            logger.error("Not enough bytes read: " + count);
        }
    }

    private void skipInput(FileInputStream file, int num_bytes) throws IOException {
        while (num_bytes > 0) {
            num_bytes = (int)((long)num_bytes - file.skip(num_bytes));
        }
    }
}

